let $$ = require('cdev/debug')({debug: 'cache', path: module.id, prefix: '[isg.xpert.archive]'});
let aguila = require('common/aguila');

let form = aguila.create({
  type: 'agorum.composite.form.basic',
  width: 1000,
  // height: 200,
  labelPosition: 'left',
  labelWidth: 200,
  elements: [
    {
      type: 'agorum.vbox',
      lite: true,
      items: [
        {
          type: 'agorum.composite.form.element.select',
          name: 'class_code_select',
          label: 'Dokumentenklasse',
          restricted: true,
          dataSource: 'MAIN_MODULE_MANAGEMENT/customers/isg.xpert.archive/Data/class_code',
          width: 300,
        },
        {
          type: 'agorum.composite.form.element.select',
          name: 'type_code_select',
          label: 'Dokumententyp',
          restricted: true,
          dataSource: 'MAIN_MODULE_MANAGEMENT/customers/isg.xpert.archive/Data/type_code',
          width: 300,
        },
        {
          type: 'agorum.composite.form.element.select',
          name: 'event_code_list_select',
          label: 'Tätigkeitskennzeichen',
          restricted: true,
          dataSource: 'MAIN_MODULE_MANAGEMENT/customers/isg.xpert.archive/Data/event_code_list',
          width: 300,
        },
      ],
    },
    {
      type: 'agorum.hbox',
      items: [
        {
          type: 'agorum.composite.form.element.text',
          name: 'class_code_text',
          width: 300,
          disabled: true,
          value: null,
        },
        {
          type: 'agorum.composite.form.element.text',
          name: 'type_code_text',
          width: 300,
          disabled: true,
          value: null,
        },
        {
          type: 'agorum.composite.form.element.text',
          name: 'event_code_list_text',
          width: 300,
          disabled: true,
          value: null,
        },
      ],
    },
  ],
});

form.on('input', input => {
  $$.debug('input', input);
  let name = input.name.replace('_select', '_text');
  form.down(name).value = input.value;
});

form;
